<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Exam extends Model 
{

    protected $table = 'exams';
    public $timestamps = true;

    public function questions()
    {
        return $this->hasMany('App\Models\Question');
    }

    public function users()
    {
        return $this->belongsToMany('App\Models\User');
    }

    public function diplomas()
    {
        return $this->morphedByMany('App\Models\Diploma', 'examable');
    }

    public function lessons()
    {
        return $this->morphedByMany('App\Models\Lesson', 'examable');
    }

}